//Exp 8.2 Program Title:To implement image segmentation based on simalarities using local threholding /
//environment: Scilab 5.5.2
//Toolbox: Image Processing Design 8.3.1-1
//Toolbox: SIVP 0.5.3.2
//Tested on OS: Windows 7 Professional, 64 bit
//Reference books names : 1)Digital Image Processing book author :
// Rafael C.Gonzalez and Richard E.Woods,
//2)Digital Image Processing book author :S.Sudhir,
//3)Digital Image Processing book author :Dhanajay Theckedath
clc //to clear command window.
clear all //to disable previously defined variables.
xdel(winsid());///clear all the previous figures plots
SIVP_PATH = getSIVPpath(); //to locate a directory in which SIVP toolbox is installed
im1=imread(SIVP_PATH + 'images/rose.bmp');//read color image from diractory
im2=rgb2gray(im1);// grey scale conversion
im2=imresize(im2,[256,256]);// resizeig of the image
im11=im2(1:128,1:128);// 128x128 first block
im12=im2(1:128,129:256);// 128x128 second block
im13=im2(129:256,1:128);// 128x128 third block
im14=im2(129:256,129:256);// 128x128 fourth block
[b11,b12,b13]=imthresholding(im11);//local thresholding on block 1
[b21,b22,b23]=imthresholding(im12);//local thresholding on block 2
[b31,b32,b33]=imthresholding(im13);//local thresholding on block 3
[b41,b42,b43]=imthresholding(im14);//local thresholding on block 4
im15=[b11,b21;b31,b41];//Concationation of all the blocks mean threshold
im16=[b12,b22;b32,b42];//Concationation of all the blocks lower mean threshold
im17=[b13,b23;b33,b43];//Concationation of all the blocks lower mean threshold
figure(1);ShowImage(im2,'Grayscale image');title('Grey scale image','color','red','fontsize',4');// displaying result
figure(2);ShowImage(im15,'Local thresholding mean of each block gray scale image');title('Local thresholding mean of each block gray scale image','color','red','fontsize',4');// displaying result
figure(3);ShowImage(im16,'Local thresholding lowermean of each block gray scale image');title('Local thresholding lowermean of each block gray scale image','color','red','fontsize',4');// displaying result
figure(4);ShowImage(im17,'Local thresholding uppermean of each block gray scale image');title('Local thresholding uppermean of each block gray scale image','color','red','fontsize',4');// displaying result
